<?php


    function ondalikEkle($total)
    {
        if (empty(explode(".", $total)[1])) {
            $total = $total . ".00";
        } else {
            if (strlen(explode(".", $total)[1]) == 1) {
                $total = $total . "0";
            }
        }
        return $total;
    }

    date_default_timezone_set('Europe/Istanbul');

    if (!defined('ABSPATH')) {
        exit;
    }
    
    $options = get_option('woocommerce_paynkolay_settings');
    
    $order = wc_get_order($order_id);

    if(isset($options['testmode']) && $options['testmode'] == 'yes') {
        $base_url = 'https://paynkolaytest.nkolayislem.com.tr/Vpos';
    } else {
        $base_url = 'https://paynkolay.nkolayislem.com.tr/Vpos';
    }

    $sx = $options['token'];
    $merchant_secret_key = $options['merchant_secret_key'];
    $amount = ondalikEkle($order->get_total());
    $successUrl = add_query_arg('wc-api', 'paynkolay', $order->get_checkout_order_received_url());
    //$failUrl = wc_get_checkout_url() . '&status=failed';
    //$failUrl = add_query_arg('status', 'failed', wc_get_cart_url());
    //receipt url
    $failUrl = add_query_arg('redirect_from', 'paynkolay', $order->get_checkout_payment_url());
    $clientRefCode = 'WooCommerce|' . $order_id . '|Woo|' . uniqid();
    $use3D = 'true';
    $rnd = date('d.m.Y H:i:s');
    $detail = 'false';
    $transactionType = 'sales';

    update_post_meta($order_id, 'client_reference_code', $clientRefCode);
    
    $hashstr = $sx . $clientRefCode . $amount . $successUrl . $failUrl . $rnd . $merchant_secret_key;
    $hashData = base64_encode(pack('H*', sha1($hashstr)));
?>

<form id="payment" action="<?php echo $base_url; ?>" method="post">
    <input type="hidden" name="sx" value="<?php echo $sx; ?>">
    <input type="hidden" name="successUrl" value="<?php echo $successUrl; ?>">
    <input type="hidden" name="failUrl" value="<?php echo $failUrl; ?>">
    <input type="hidden" name="amount" value="<?php echo $amount; ?>">
    <input type="hidden" name="clientRefCode" value="<?php echo $clientRefCode; ?>">
    <input type="hidden" name="productId" value="">
    <input type="hidden" name="use3D" value="<?php echo $use3D; ?>">
    <input type="hidden" name="rnd" value="<?php echo $rnd; ?>">
    <input type="hidden" name="detail" value="<?php echo $detail; ?>">
    <input type="hidden" name="transactionType" value="<?php echo $transactionType; ?>">
    <input type="hidden" name="hashData" value="<?php echo $hashData; ?>">
    <input type="hidden" name="ECOMM_PLATFORM" value="Wordpress(AutoComplate2024.10.16)">
    <button>Ödeme işlemine devam et</button>
</form>

<style>
    body {
        display: none!important;
    }
</style>

<script>
    document.getElementById('payment').submit();
</script>