<?php
/*
  Plugin Name: Nkolay Bağış Ödeme Geçidi
  Version: 1.0.0
  Description: NKolay Payment Gateway add-on for Give Donation
  Text Domain: give-nkolay
*/

/* Prevent File from direct open */
if (!defined('ABSPATH')) {
    die();
}

if (!class_exists('Give_NKolay_Gateway')) {
    final class Give_NKolay_Gateway
    {
        /**
         * Hold Instance of current class object
         * @var object
         * @access private
         * @static
         */
        private static $instance;

        /**
         * Notices (array)
         *
         * @since 0.0.1
         *
         * @var array
         */
        public $notices = [];

        /**
         * NKolay admin settings
         * @return object
         */
        public $admin_settings;

        // Initialize Give NKolay Gateway
        public static function init()
        {
            if (!isset(self::$instance)) {
                self::$instance = new Give_NKolay_Gateway();
            }
            self::$instance->setup();
        }

        /**
         * Setup Give NKolay Gateway
         * @access private
         * @since 0.0.1
         */
        private function setup()
        {
            // Init constants
            self::$instance->constants();
            // Registration Hooks

            // Add Hooks
            add_action('give_init', [$this, 'give_init'], 10);
            add_action('admin_init', [$this, 'check_environment'], 999);
            add_action('admin_notices', [$this, 'admin_notices'], 15);
        }

        /**
         * Check plugin environment.
         *
         * @since  0.0.1
         * @access public
         *
         * @return bool
         */
        public function check_environment()
        {
            // Flag to check whether plugin file is loaded or not.
            $is_loaded = true;

            // Check for if give plugin activate or not.
            $is_give_active = defined('GIVE_PLUGIN_BASENAME') ? is_plugin_active(GIVE_PLUGIN_BASENAME) : false;

            if (empty($is_give_active)) {
                // Show admin notice.
                $this->add_admin_notice(
                    'is_give_activate',
                    'error',
                    sprintf(
                        __('<strong>Activation Error:</strong> You must have the <a href="%s" target="_blank">Give</a> plugin installed and activated for the Give - NKolay Payment Gateway Add-on to activate.', 'give-nkolay'),
                        'https://givewp.com'
                    )
                );
                $is_loaded = false;
            }

            return $is_loaded;
        }

        /**
         *  Setup Constants
         * @access private
         * @since 0.0.1
         */
        private function constants()
        {
            if (!defined('GIVE_NKOLAY_GATEWAY_VERSION')) {
                define('GIVE_NKOLAY_GATEWAY_VERSION', '0.0.1');
            }
            if (!defined('GIVE_NKOLAY_GATEWAY_SLUG')) {
                define('GIVE_NKOLAY_GATEWAY_SLUG', 'give-nkolay-payment-gateway');
            }
            if (!defined('GIVE_NKOLAY_GATEWAY_FILE')) {
                define('GIVE_NKOLAY_GATEWAY_FILE', __FILE__);
            }
            if (!defined('GIVE_NKOLAY_GATEWAY_DIR')) {
                define('GIVE_NKOLAY_GATEWAY_DIR', dirname(GIVE_NKOLAY_GATEWAY_FILE));
            }
            if (!defined('GIVE_NKOLAY_GATEWAY_URL')) {
                define('GIVE_NKOLAY_GATEWAY_URL', plugin_dir_url(GIVE_NKOLAY_GATEWAY_FILE));
            }
            if (!defined('GIVE_NKOLAY_GATEWAY_BASENAME')) {
                define('GIVE_NKOLAY_GATEWAY_BASENAME', plugin_basename(GIVE_NKOLAY_GATEWAY_FILE));
            }
        }

        /**
         *  Give NKolay Payment Includes
         * @access protected
         * @since 0.0.1
         */
        protected function includes()
        {
            // Admin Settings Class
            include_once GIVE_NKOLAY_GATEWAY_DIR . '/inc/class-give-nkolay-settings.php';
            // Call Admin  Class
            self::$instance->admin_settings = new Give_NKolay_Settings();

            // Frontend NKolay Credit Form Class
            include_once GIVE_NKOLAY_GATEWAY_DIR . '/inc/class-nkolay-credit-card.php';
            // Call Form Class
            new Give_NKolay_Credit_Card();
        }

        /**
         * Call on give init action
         * @return void
         * @access public
         * @method give_init
         * @since 0.0.1
         */
        public function give_init()
        {
            self::$instance->includes();
        }

        /**
         * Allow this class and other classes to add notices.
         *
         * @since 0.0.1
         *
         * @param $slug
         * @param $class
         * @param $message
         */
        public function add_admin_notice($slug, $class, $message)
        {
            $this->notices[$slug] = [
                'class' => $class,
                'message' => $message,
            ];
        }

        /**
         * Display admin notices.
         *
         * @since 0.0.1
         */
        public function admin_notices()
        {
            $allowed_tags = [
                'a' => [
                    'href' => [],
                    'title' => [],
                    'class' => [],
                    'id' => [],
                ],
                'br' => [],
                'em' => [],
                'span' => [
                    'class' => [],
                ],
                'strong' => [],
            ];

            foreach ((array) $this->notices as $notice_key => $notice) {
                echo "<div class='" . esc_attr($notice['class']) . "'><p>";
                echo wp_kses($notice['message'], $allowed_tags);
                echo '</p></div>';
            }
        }
    }
}

// Init NKolay Plugin
Give_NKolay_Gateway::init();

add_action('init', 'nkolaygive_callback');

function nkolaygive_callback()
{
    if (strpos($_SERVER['REQUEST_URI'], "nkolaygive_callback") !== false) {

        if (isset($_POST['REFERENCE_CODE']) && isset($_POST['RESPONSE_CODE'])) {
            $form_id = $_GET['form_id'];



            $merchantSecretKey = give_get_option('give_nkolay_secret_key');
            $REFERENCE_CODE = $_POST['REFERENCE_CODE'];
            $RESPONSE_CODE = $_POST['RESPONSE_CODE'];
            $USE_3D = $_POST['USE_3D'];
            $MERCHANT_NO = $_POST['MERCHANT_NO'];
            $AUTH_CODE = $_POST['AUTH_CODE'];
            $CLIENT_REFERENCE_CODE = $_POST['CLIENT_REFERENCE_CODE'];
            $AUTHORIZATION_AMOUNT = $_POST['AUTHORIZATION_AMOUNT'];
            $INSTALLMENT = $_POST['INSTALLMENT'];
            $RND = $_POST['RND'];
            $hashData = $_POST['hashData'];
            $merchantSecretKey;
            $donation_id = explode('|G|', $CLIENT_REFERENCE_CODE);

            $donation_id = $donation_id[0];

            $donation_id = str_replace(give_get_option('give_nkolay_prefix'), '', $donation_id);

            $hashtr = $MERCHANT_NO . $REFERENCE_CODE . $AUTH_CODE . $RESPONSE_CODE . $USE_3D . $RND . $INSTALLMENT . $AUTHORIZATION_AMOUNT . $merchantSecretKey;
            $hashDatauretilen = base64_encode(pack('H*', sha1($hashtr)));

            $url = "https://paynkolay.nkolayislem.com.tr/Vpos/Payment/CompletePayment";

            if ($_POST['USE_3D'] == 'false' && $_POST['hashData'] == $hashDatauretilen) {

                if ($_POST['RESPONSE_CODE'] == 2 && $_POST['hashData'] == $hashDatauretilen) {
            
                    give_update_payment_status($donation_id, 'completed');
                    give_send_to_success_page();
                    exit();
                } else {
                    setcookie("nkolay_error", __( 'An error occurred while processing the donation. Please try again.', 'give' ));
                    //give_send_back_to_checkout('?payment-mode=nkolay_credit_card');
                    wp_safe_redirect( get_permalink( $form_id ) );
                    give_die();
                    exit();
                }
            } else {

                if ($_POST['RESPONSE_CODE'] == 2 && $_POST['hashData'] == $hashDatauretilen) {
 
                    $ch = curl_init();
                    $arrData = [
                        "sx" => give_get_option('give_nkolay_sxkey'),
                        "referenceCode" => $REFERENCE_CODE,
                    ];
                    
                    curl_setopt($ch, CURLOPT_URL, $url);
                    curl_setopt($ch, CURLOPT_POST, 1);
                    curl_setopt($ch, CURLOPT_POSTFIELDS, $arrData);
                    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                    $server_output = curl_exec($ch);
                    error_log($server_output);
                    $result = json_decode($server_output);

                    $result = json_decode($result->result);

                    if ($result->RESPONSE_CODE == 2) {

                        give_update_payment_status($donation_id, 'completed');
                        give_send_to_success_page();
                        exit();
                    } else {
                        setcookie("nkolay_error", __( 'An error occurred while processing the donation. Please try again.', 'give' ));

                        wp_safe_redirect( get_permalink( $form_id ) );
		                give_die();
                    }
                } else {
                    setcookie("nkolay_error", __( 'An error occurred while processing the donation. Please try again.', 'give' ));
 
                    wp_safe_redirect( get_permalink( $form_id ) );
		            give_die();
                }
            }
        }
    }
}