<?php
/*
  Add Payment Gateway method in Give WP
*/
class Give_NKolay_Settings{

  // public class Constructor
  public function __construct(){
    //Init Setting Payemnt gateway settings
    $this->init();
  }
  // Prefix for nkolay
  protected $prefix = 'give_nkolay';
  // Init hooks
  protected function init(){
    add_filter( 'give_payment_gateways', array( $this, 'give_nkolay_payment_gateways') );
    add_filter( 'give_get_sections_gateways', array( $this, 'give_register_nkolay_payment_gateway_sections') );
    add_filter( 'give_get_settings_gateways', array( $this, 'give_register_nkolay_payment_gateway_setting_fields') );
  }
  // CardKnox Payment methods
  public function give_nkolay_payment_gateways( $gateways ){
      // Add nkolay Payment Methods
      $gateways['nkolay_credit_card'] = array(
        'admin_label' => __('Nkolay Bağış Ödeme Geçidi', 'give-nkolay'),
        'checkout_label' =>  __('Kredi Kartı', 'give-nkolay'),
      );

      return $gateways;
  }

  /**
   * Register Section for Payment Gateway Settings.
   *
   * @param array $sections List of payment gateway sections.
   *
   * @since 1.0.0
   *
   * @return array
   */

  function give_register_nkolay_payment_gateway_sections( $sections ) {

  	$sections['nkolay-settings'] = __( 'NKolay', 'give-nkolay' );

  	return $sections;
  }

  /**
   * Register Admin Settings.
   *
   * @param array $settings List of admin settings.
   *
   * @since 1.0.0
   *
   * @return array
   */
  function give_register_nkolay_payment_gateway_setting_fields( $settings ) {

  	switch ( give_get_current_setting_section() ) {

  		case 'nkolay-settings':
    			$settings = array(
    				array(
    					'id'   => 'give_title_nkolay',
    					'type' => 'title',
    				),
            array(
              'name' => __( 'SX Key', 'give-nkolay' ),
              'desc' => __( 'Enter your SX Key', 'give-nkolay' ),
              'id'   => 'give_nkolay_sxkey',
              'type' => 'text',
            ),
            array(
              'name' => __( 'Secret Key', 'give-nkolay' ),
              'desc' => __( 'Enter your Merchant Secret Key', 'give-nkolay' ),
              'id'   => 'give_nkolay_secret_key',
              'type' => 'text',
            ),
            array(
              'name' => __( 'Prefix', 'give-nkolay' ),
              'desc' => __( 'Enter your Reference Prefix', 'give-nkolay' ),
              'id'   => 'give_nkolay_prefix',
              'type' => 'text',
            ),
            array(
              'name' => __('3D Required', 'give-nkolay'),
              'id'   => 'give_nkolay_threed',
              'type'  => 'checkbox',
              'desc'  => __('If you want to your customer have use 3D', 'give-nkolay')
            ),
            array(
              'name' => __('Require Billing Field', 'give-nkolay'),
              'id'   => 'give_nkolay_disable_address_fields',
              'type'  => 'checkbox',
              'desc'  => __('If you dont want billing fields', 'give-nkolay')
            ),
            array(
      				'id'   => 'give_title_nkolay',
      				'type' => 'sectionend',
      			)
    			);
  			break;

  	} // End switch().

  	return $settings;
  }

}
