<?php
class Nkolay_NkolayPos_PaymentController extends Mage_Core_Controller_Front_Action
{
    public function redirectAction()
    {
        $model = Mage::getModel('nkolaypos/paymentmethod')->form();

        $sandbox = Mage::getStoreConfig('payment/nkolaypos/sandbox');

        $url = "https://paynkolay.nkolayislem.com.tr/Vpos";
		

		if($sandbox == 1){
			$url = "https://paynkolaytest.nkolayislem.com.tr/VposNew";
		}

        $form = "<form id='nkolay-form' action='" . $url . "' method='post'>";
        foreach($model as $key => $value){
            $form .= "<input type='hidden' name='". $key ."' value='". $value ."'>";
        }
        $form .= '<form><script>document.getElementById("nkolay-form").submit()</script>';

        echo $form; exit;
        
    }

    public function responseAction()
    {
        $params = $this->getRequest()->getPost();

        $order_id = $params['CLIENT_REFERENCE_CODE'];
        $order_id = explode('|MAGENTO|', $order_id);
        $order_id = current($order_id);

        $sandbox = Mage::getStoreConfig('payment/nkolaypos/sandbox'); 

		$url = "https://paynkolay.nkolayislem.com.tr/Vpos/Payment/CompletePayment";

		if($sandbox == 1){
			$url = "https://paynkolaytest.nkolayislem.com.tr/VposNew/Payment/CompletePayment";
		}

        $merchantSecretKey = Mage::getStoreConfig('payment/nkolaypos/secretkey');

		$REFERENCE_CODE = $params['REFERENCE_CODE'];
		$RESPONSE_CODE = $params['RESPONSE_CODE'];
		$USE_3D = $params['USE_3D'];
		$MERCHANT_NO = $params['MERCHANT_NO'];
		$AUTH_CODE = $params['AUTH_CODE'];
		$CLIENT_REFERENCE_CODE = $params['CLIENT_REFERENCE_CODE'];
		$AUTHORIZATION_AMOUNT = $params['AUTHORIZATION_AMOUNT'];
		$INSTALLMENT = $params['INSTALLMENT'];
		$RND = $params['RND'];
		$hashData = $params['hashData'];
		$merchantSecretKey;


		$hashtr = $MERCHANT_NO . $REFERENCE_CODE . $AUTH_CODE . $RESPONSE_CODE . $USE_3D . $RND . $INSTALLMENT . $AUTHORIZATION_AMOUNT . $merchantSecretKey ;
		$hashDatauretilen = base64_encode(pack('H*',sha1($hashtr)));


        $order = Mage::getSingleton('sales/order')->loadByIncrementId($order_id);

        if($params['USE_3D'] == 'false' && $params['hashData'] == $hashDatauretilen){
 
			if($params['RESPONSE_CODE'] == 2 && $params['hashData'] == $hashDatauretilen){

				$order->setState(Mage_Sales_Model_Order::STATE_PROCESSING, true)->save();
                try {
                    $order->sendNewOrderEmail();
                    
                } catch (Exception $e) {
                    Mage::log($e->getMessage(), null, 'nkolay.error.log', true);
                }

                header("Location: /checkout/onepage/success");
               exit();
			} else {
				$this->addCart($order, $params);
                header("Location: /checkout/cart");
               exit();
			}
		} else {
 
			if($params['RESPONSE_CODE'] == 2 && $params['hashData'] == $hashDatauretilen){

				$ch = curl_init(); 
				$arrData = array( 
				"sx" => Mage::getStoreConfig('payment/nkolaypos/sxkey'), 
				"referenceCode" => $REFERENCE_CODE 
				); 
				curl_setopt($ch, CURLOPT_URL, $url); 
				curl_setopt($ch, CURLOPT_POST, 1); 
				curl_setopt($ch, CURLOPT_POSTFIELDS, $arrData); 
				curl_setopt($ch, CURLOPT_RETURNTRANSFER, true); 
				$server_output = curl_exec($ch); 
	
			
				$result = json_decode($server_output); 

				
	
				$result = json_decode($result->result);
	
				if($result->RESPONSE_CODE == 2){
					$order->setState(Mage_Sales_Model_Order::STATE_PROCESSING, true)->save();
                    try {
                        $order->sendNewOrderEmail();
                        
                    } catch (Exception $e) {
                        Mage::log($e->getMessage(), null, 'nkolay.error.log', true);
                    }

                    header("Location: /checkout/onepage/success");
                   exit();
				} else {
					$this->addCart($order, $params);
                    header("Location: /checkout/cart");
                   exit();
				}
	
	
			} else {
				$this->addCart($order, $params);
                header("Location: /checkout/cart");
               exit();
			}
		}

    }

    private function addCart($order, $params)
    {
        foreach ($order->getAllItems() as $item) {
            $product = Mage::getModel('catalog/product')->load($item->getProductId());

            $params = [
                'product' => $product->getId(),
                'qty' => $item->getQtyOrdered(),
            ];

            $cart = Mage::getModel('checkout/cart');
            $cart->init();
            $cart->addProduct($product, $params);
            $cart->save();

            $quote = Mage::getModel('checkout/session')->getQuote();
            $quote->collectTotals()->save();
        }

        $order->setState(Mage_Sales_Model_Order::STATE_CANCELED, true)->save();
        Mage::getSingleton('core/session')->addError($params['RESPONSE_DATA']);
    }

}
