<?php

    namespace Nkolay\NkolayPos\Controller\Sanalpos;

    use Magento\Framework\Controller\ResultFactory;
    use Magento\Framework\App\CsrfAwareActionInterface;
    use Magento\Framework\App\RequestInterface;
    use Magento\Framework\App\Request\InvalidRequestException;
    use Magento\Quote\Model\QuoteIdToMaskedQuoteIdInterface;

    class D3 extends \Magento\Framework\App\Action\Action
    {
        protected $_context;
        protected $_pageFactory;
        protected $_jsonEncoder;
        protected $_resultRedirect;
        protected $_checkoutSession;
        protected $_customerSession;
        protected $_scopeConfig;
        protected $_storeManager;
        protected $_redirect;
        protected $_coreSession;
        protected $_messageManager;
        protected $_cartManagement;
        protected $_quoteIdToMaskedQuoteId;
        protected $_guestCartManagement;

        public function __construct(
            \Magento\Framework\App\Action\Context                            $context,
            \Magento\Framework\Json\EncoderInterface                         $encoder,
            \Magento\Framework\View\Result\PageFactory                       $pageFactory,
            \Magento\Checkout\Model\Session                                  $checkoutSession,
            \Magento\Customer\Model\Session                                  $customerSession,
            \Magento\Quote\Api\CartManagementInterface                       $cartManagement,
            \Magento\Framework\App\Config\ScopeConfigInterface               $scopeConfig,
            \Magento\Framework\Session\SessionManagerInterface               $coreSession,
            \Magento\Framework\App\Response\RedirectInterface                $redirect,
            \Magento\Framework\Message\ManagerInterface                      $messageManager,
            \Magento\Checkout\Api\GuestPaymentInformationManagementInterface $guestCartManagement,
            \Magento\Store\Model\StoreManagerInterface                       $storeManager,
            QuoteIdToMaskedQuoteIdInterface                                  $quoteIdToMaskedQuoteId

        )
        {
            $this->_context = $context;
            $this->_pageFactory = $pageFactory;
            $this->_jsonEncoder = $encoder;
            $this->_checkoutSession = $checkoutSession;
            $this->_customerSession = $customerSession;
            $this->_scopeConfig = $scopeConfig;
            parent::__construct($context);
            $this->_resultRedirect = $context->getResultFactory();
            $this->_storeManager = $storeManager;
            $this->_messageManager = $messageManager;
            $this->_redirect = $redirect;
            $this->_coreSession = $coreSession;
            $this->_cartManagement = $cartManagement;
            $this->_guestCartManagement = $guestCartManagement;
            $this->_quoteIdToMaskedQuoteId = $quoteIdToMaskedQuoteId;
            $this->checkAndSetCookieSameSite();
        }

        public function execute()
        {

            $objectManager = \Magento\Framework\App\ObjectManager::getInstance();
            $storeManager = $objectManager->get('\Magento\Store\Model\StoreManagerInterface');
            $site_url = $storeManager->getStore()->getBaseUrl();

            $resultRedirect = $this->_resultRedirect->create(ResultFactory::TYPE_REDIRECT);

            $sandbox = $this->_scopeConfig->getValue('payment/nkolay_pos/sandbox');

            $form_type = $this->_scopeConfig->getValue('payment/nkolay_pos/form_type');


            $url = "https://paynkolay.nkolayislem.com.tr/Vpos";


            if ($sandbox == 1) {
                $url = "https://paynkolaytest.nkolayislem.com.tr/Vpos";
            }
            date_default_timezone_set("Europe/Istanbul");
            $objectManager = \Magento\Framework\App\ObjectManager::getInstance();
            $cartObj = $objectManager->get('\Magento\Checkout\Model\Cart');
            $grandTotal = $cartObj->getQuote()->getGrandTotal();
            $checkoutSession = $this->_checkoutSession->getQuote();
            $data['action'] = $url;
            $callback = $this->_storeManager->getStore()->getBaseUrl() . 'nkolay/sanalpos/response';

            $sx = $this->_scopeConfig->getValue('payment/nkolay_pos/sxkey');
            $merchantSecretKey = $this->_scopeConfig->getValue('payment/nkolay_pos/merchantkey');
            $successUrl = $callback;
            $failUrl = $callback;

            $grandTotal = number_format($_REQUEST['odenecek_tutar'], "2", ".", "");
            $amount = $grandTotal;
            $clientRefCode = $checkoutSession->getId() . '|MAGENTO|' . uniqid();
            $use3D = $this->_scopeConfig->getValue('payment/nkolay_pos/threed') == '1' ? 'true' : 'false';
            $rnd = time();
            $detail = "false";
            $transactionType = "SALES";

            $hashstr = $sx . $clientRefCode . $amount . $successUrl . $failUrl . $rnd . $merchantSecretKey;

            $hashData = base64_encode(pack('H*', sha1($hashstr)));

            $data = [
                'sx' => $sx,
                'clientRefCode' => $clientRefCode,
                'successUrl' => $successUrl,
                'failUrl' => $failUrl,
                'amount' => $amount,
                'installmentNo' => $_REQUEST['secilen_taksit'],
                'cardHolderName' => $_REQUEST['cardHolderName'],
                'month' => $_REQUEST['ay'],
                'year' => $_REQUEST['yil'],
                'cvv' => $_REQUEST['cvv'],
                'cardNumber' => $_REQUEST['cardNumber'],
                'EncodedValue' => $_REQUEST['tsx' . $_REQUEST['secilen_taksit']],
                'use3D' => $use3D,
                'transactionType' => 'SALES',
                'hosturl' => $site_url,
                'rnd' => $rnd,
                'hashData' => $hashData,
                'environment' => 'API',
            ];
            $result = json_decode($this->curl($data, $url . "/Payment/Payment"));


            if ($result->USE_3D == "false") {

                /*
                 * 3d değilse işlem yapar
                 */

                $yonlen = $site_url . "nkolay/sanalpos/nonsecure?hashData=$hashData&clientRefCode=$clientRefCode&amount=$amount&rnd=$rnd";
                
                header("Location: $yonlen");
                exit;

            } else {
                /*
                 * 3d ise işlem yapar
                 */

                if ($result->RESPONSE_CODE != 2) {

                    $this->_messageManager->addErrorMessage($result->RESPONSE_DATA);
                    $resultRedirect->setPath('checkout/cart', ['_secure' => true]);
                    return $resultRedirect;
                } else {
                    print_r($result->BANK_REQUEST_MESSAGE);
                }

            }
            exit;


        }

        public function curl($par, $url)
        {
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_HTTPHEADER, array());
            curl_setopt($ch, CURLOPT_URL, $url);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_HEADER, false);
            curl_setopt($ch, CURLOPT_POST, 1);
            curl_setopt($ch, CURLOPT_POSTFIELDS, $par);
            $output = curl_exec($ch);
            curl_close($ch);
            return $output;
        }

        private function checkAndSetCookieSameSite()
        {
            foreach ($_COOKIE as $cookieName => $value) {
                $this->setcookieSameSite($cookieName, $_COOKIE[$cookieName], time() + 86400, "/", $_SERVER['SERVER_NAME'], true, true);
            }
        }

        private function setcookieSameSite($name, $value, $expire, $path, $domain, $secure, $httponly)
        {

            if (PHP_VERSION_ID < 70300) {

                setcookie($name, $value, $expire, "$path; samesite=None", $domain, $secure, $httponly);
            } else {
                setcookie($name, $value, [
                    'expires' => $expire,
                    'path' => $path,
                    'domain' => $domain,
                    'samesite' => 'None',
                    'secure' => $secure,
                    'httponly' => $httponly
                ]);


            }
        }

        private function getQuoteMaskId($quoteId)
        {
            $maskedId = null;
            try {
                $maskedId = $this->_quoteIdToMaskedQuoteId->execute($quoteId);
            } catch (NoSuchEntityException $exception) {
                throw new LocalizedException(__('Current user does not have an active cart.'));
            }

            return $maskedId;
        }
    }