<?php

    namespace Nkolay\NkolayPos\Controller\Sanalpos;

    use Magento\Framework\Controller\ResultFactory;
    use Magento\Framework\App\CsrfAwareActionInterface;
    use Magento\Framework\App\RequestInterface;
    use Magento\Framework\App\Request\InvalidRequestException;
    use Magento\Quote\Model\QuoteIdToMaskedQuoteIdInterface;

    class Index extends \Magento\Framework\App\Action\Action
    {
        protected $_context;
        protected $_pageFactory;
        protected $_jsonEncoder;
        protected $_resultRedirect;
        protected $_checkoutSession;
        protected $_customerSession;
        protected $_scopeConfig;
        protected $_storeManager;
        protected $_redirect;
        protected $_coreSession;
        protected $_messageManager;
        protected $_cartManagement;
        protected $_quoteIdToMaskedQuoteId;
        protected $_guestCartManagement;

        public function __construct(
            \Magento\Framework\App\Action\Context                            $context,
            \Magento\Framework\Json\EncoderInterface                         $encoder,
            \Magento\Framework\View\Result\PageFactory                       $pageFactory,
            \Magento\Checkout\Model\Session                                  $checkoutSession,
            \Magento\Customer\Model\Session                                  $customerSession,
            \Magento\Quote\Api\CartManagementInterface                       $cartManagement,
            \Magento\Framework\App\Config\ScopeConfigInterface               $scopeConfig,
            \Magento\Framework\Session\SessionManagerInterface               $coreSession,
            \Magento\Framework\App\Response\RedirectInterface                $redirect,
            \Magento\Framework\Message\ManagerInterface                      $messageManager,
            \Magento\Checkout\Api\GuestPaymentInformationManagementInterface $guestCartManagement,
            \Magento\Store\Model\StoreManagerInterface                       $storeManager,
            QuoteIdToMaskedQuoteIdInterface                                  $quoteIdToMaskedQuoteId

        )
        {
            $this->_context = $context;
            $this->_pageFactory = $pageFactory;
            $this->_jsonEncoder = $encoder;
            $this->_checkoutSession = $checkoutSession;
            $this->_customerSession = $customerSession;
            $this->_scopeConfig = $scopeConfig;
            parent::__construct($context);
            $this->_resultRedirect = $context->getResultFactory();
            $this->_storeManager = $storeManager;
            $this->_messageManager = $messageManager;
            $this->_redirect = $redirect;
            $this->_coreSession = $coreSession;
            $this->_cartManagement = $cartManagement;
            $this->_guestCartManagement = $guestCartManagement;
            $this->_quoteIdToMaskedQuoteId = $quoteIdToMaskedQuoteId;
            $this->checkAndSetCookieSameSite();
        }

        public function execute()
        {

            $resultRedirect = $this->_resultRedirect->create(ResultFactory::TYPE_REDIRECT);

            $sandbox = $this->_scopeConfig->getValue('payment/nkolay_pos/sandbox');

            $form_type = $this->_scopeConfig->getValue('payment/nkolay_pos/form_type');


            $url = "https://paynkolay.nkolayislem.com.tr/Vpos";


            if ($sandbox == 1) {
                $url = "https://paynkolaytest.nkolayislem.com.tr/Vpos";
            }
            date_default_timezone_set("Europe/Istanbul");
            $objectManager = \Magento\Framework\App\ObjectManager::getInstance();
            $cartObj = $objectManager->get('\Magento\Checkout\Model\Cart');
            $grandTotal = $cartObj->getQuote()->getGrandTotal();
            $checkoutSession = $this->_checkoutSession->getQuote();
            $data['action'] = $url;
            $callback = $this->_storeManager->getStore()->getBaseUrl() . 'nkolay/sanalpos/response';

            $sx = $this->_scopeConfig->getValue('payment/nkolay_pos/sxkey');
            $merchantSecretKey = $this->_scopeConfig->getValue('payment/nkolay_pos/merchantkey');
            $successUrl = $callback;
            $failUrl = $callback;

            $grandTotal = number_format($grandTotal, "2", ".", "");
            $amount = $grandTotal;
            $clientRefCode = $checkoutSession->getId() . '|MAGENTO|' . uniqid();
            $use3D = $this->_scopeConfig->getValue('payment/nkolay_pos/threed') == '1' ? 'true' : 'false';
            $rnd = date("d.m.Y H:i:s");
            $detail = "false";
            $transactionType = "SALES";

            $hashstr = $sx . $clientRefCode . $amount . $successUrl . $failUrl . $rnd . $merchantSecretKey;

            $hashData = base64_encode(pack('H*', sha1($hashstr)));

            $data = [
                'sx' => $sx,
                'successUrl' => $successUrl,
                'failUrl' => $failUrl,
                'amount' => $amount,
                'clientRefCode' => $clientRefCode,
                'use3D' => $use3D,
                'rnd' => $rnd,
                'detail' => $detail,
                'transactionType' => $transactionType,
                'hashData' => $hashData,
            ];



            $form = "<form id='nkolay-form' action='" . $url . "' method='post'>";
            foreach ($data as $key => $value) {
                $form .= "<input type='hidden' name='" . $key . "' value='" . $value . "'>";
            }

            $form .= '<form><script>document.getElementById("nkolay-form").submit()</script>';

            if ($form_type == "ortak_odeme") {

                echo $form;
                exit;
            } else {

                $resultPage  = $this->_pageFactory->create();
                $resultPage->addHandle('default');

                $resultPage->addHandle('nkolaypos_index_index');
                $resultPage->getConfig()->getTitle()->prepend("Ödeme");

                return $resultPage;
            }
        }

        private function checkAndSetCookieSameSite()
        {
            foreach ($_COOKIE as $cookieName => $value) {
                $this->setcookieSameSite($cookieName, $_COOKIE[$cookieName], time() + 86400, "/", $_SERVER['SERVER_NAME'], true, true);
            }
        }

        private function setcookieSameSite($name, $value, $expire, $path, $domain, $secure, $httponly)
        {

            if (PHP_VERSION_ID < 70300) {

                setcookie($name, $value, $expire, "$path; samesite=None", $domain, $secure, $httponly);
            } else {
                setcookie($name, $value, [
                    'expires' => $expire,
                    'path' => $path,
                    'domain' => $domain,
                    'samesite' => 'None',
                    'secure' => $secure,
                    'httponly' => $httponly
                ]);


            }
        }

    }