<?php

    namespace Nkolay\NkolayPos\Controller\Sanalpos;

    use Magento\Framework\Controller\ResultFactory;
    use Magento\Framework\App\CsrfAwareActionInterface;
    use Magento\Framework\App\RequestInterface;
    use Magento\Framework\App\Request\InvalidRequestException;
    use Magento\Quote\Model\QuoteIdToMaskedQuoteIdInterface;

    class Nonsecure extends \Magento\Framework\App\Action\Action
    {
        protected $_context;
        protected $_pageFactory;
        protected $_jsonEncoder;
        protected $_resultRedirect;
        protected $_checkoutSession;
        protected $_customerSession;
        protected $_scopeConfig;
        protected $_storeManager;
        protected $_redirect;
        protected $_coreSession;
        protected $_messageManager;
        protected $_cartManagement;
        protected $_quoteIdToMaskedQuoteId;
        protected $_guestCartManagement;

        public function __construct(
            \Magento\Framework\App\Action\Context                            $context,
            \Magento\Framework\Json\EncoderInterface                         $encoder,
            \Magento\Framework\View\Result\PageFactory                       $pageFactory,
            \Magento\Checkout\Model\Session                                  $checkoutSession,
            \Magento\Customer\Model\Session                                  $customerSession,
            \Magento\Quote\Api\CartManagementInterface                       $cartManagement,
            \Magento\Framework\App\Config\ScopeConfigInterface               $scopeConfig,
            \Magento\Framework\Session\SessionManagerInterface               $coreSession,
            \Magento\Framework\App\Response\RedirectInterface                $redirect,
            \Magento\Framework\Message\ManagerInterface                      $messageManager,
            \Magento\Checkout\Api\GuestPaymentInformationManagementInterface $guestCartManagement,
            \Magento\Store\Model\StoreManagerInterface                       $storeManager,
            QuoteIdToMaskedQuoteIdInterface                                  $quoteIdToMaskedQuoteId

        )
        {
            $this->_context = $context;
            $this->_pageFactory = $pageFactory;
            $this->_jsonEncoder = $encoder;
            $this->_checkoutSession = $checkoutSession;
            $this->_customerSession = $customerSession;
            $this->_scopeConfig = $scopeConfig;
            parent::__construct($context);
            $this->_resultRedirect = $context->getResultFactory();
            $this->_storeManager = $storeManager;
            $this->_messageManager = $messageManager;
            $this->_redirect = $redirect;
            $this->_coreSession = $coreSession;
            $this->_cartManagement = $cartManagement;
            $this->_guestCartManagement = $guestCartManagement;
            $this->_quoteIdToMaskedQuoteId = $quoteIdToMaskedQuoteId;
            $this->checkAndSetCookieSameSite();
        }

        public function execute()
        {

            $callback = $this->_storeManager->getStore()->getBaseUrl() . 'nkolay/sanalpos/response';
            $successUrl = $callback;
            $failUrl = $callback;
            $hashDataGelen = $_REQUEST['hashData'];
            $clientRefCode = $_REQUEST['clientRefCode'];
            $amount = $_REQUEST['amount'];
            $rnd = $_REQUEST['rnd'];
            $merchantSecretKey = $this->_scopeConfig->getValue('payment/nkolay_pos/merchantkey');


            $sx = $this->_scopeConfig->getValue('payment/nkolay_pos/sxkey');

            $hashstr = $sx . $clientRefCode . $amount . $successUrl . $failUrl . $rnd . $merchantSecretKey;

            $hashData = base64_encode(pack('H*', sha1($hashstr)));

            if($hashData ==$hashDataGelen){
                $objectManager = \Magento\Framework\App\ObjectManager::getInstance();
                $storeManager = $objectManager->get('\Magento\Store\Model\StoreManagerInterface');
                $site_url = $storeManager->getStore()->getBaseUrl();
                $resultRedirect = $this->_resultRedirect->create(ResultFactory::TYPE_REDIRECT);
                $sandbox = $this->_scopeConfig->getValue('payment/nkolay_pos/sandbox');

                $checkoutSession = $this->_checkoutSession->getQuote();
                $payment_type = $checkoutSession->getPayment()->setMethod('nkolay_pos');
                $this->_quote = $this->_checkoutSession->getQuote();
                $customerId = 0;
                $billingAddress = $checkoutSession->getBillingAddress();
                if ($billingAddress->getEmail()) {
                    $email = $billingAddress->getEmail();
                } else {
                    $email = $this->_customerSession->getCustomer()->getEmail();
                }

                if ($this->_customerSession->isLoggedIn()) {

                    $this->_cartManagement->placeOrder($checkoutSession->getId());

                } else {

                    $quoteId = $this->getQuoteMaskId($checkoutSession->getId());
                    try {
                        $this->_guestCartManagement->savePaymentInformationAndPlaceOrder($quoteId, $email, $payment_type, $this->_checkoutSession->getBillingAddress());

                    } catch (\Exception $e) {

                        echo $e->getMessage();
                        exit;
                    }
                }
                $resultRedirect->setPath('checkout/onepage/success');
                return $resultRedirect;
            } else {
                exit("hatalı işlem");
            }
        }

        public function curl($par, $url)
        {
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_HTTPHEADER, array());
            curl_setopt($ch, CURLOPT_URL, $url);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_HEADER, false);
            curl_setopt($ch, CURLOPT_POST, 1);
            curl_setopt($ch, CURLOPT_POSTFIELDS, $par);
            $output = curl_exec($ch);
            curl_close($ch);
            return $output;
        }

        private function checkAndSetCookieSameSite()
        {
            foreach ($_COOKIE as $cookieName => $value) {
                $this->setcookieSameSite($cookieName, $_COOKIE[$cookieName], time() + 86400, "/", $_SERVER['SERVER_NAME'], true, true);
            }
        }

        private function setcookieSameSite($name, $value, $expire, $path, $domain, $secure, $httponly)
        {

            if (PHP_VERSION_ID < 70300) {

                setcookie($name, $value, $expire, "$path; samesite=None", $domain, $secure, $httponly);
            } else {
                setcookie($name, $value, [
                    'expires' => $expire,
                    'path' => $path,
                    'domain' => $domain,
                    'samesite' => 'None',
                    'secure' => $secure,
                    'httponly' => $httponly
                ]);


            }
        }

        private function getQuoteMaskId($quoteId)
        {
            $maskedId = null;
            try {
                $maskedId = $this->_quoteIdToMaskedQuoteId->execute($quoteId);
            } catch (NoSuchEntityException $exception) {
                throw new LocalizedException(__('Current user does not have an active cart.'));
            }

            return $maskedId;
        }
    }