<?php

class Nkolay
{ 
    public static $urls = [
        'checkout' => [
            'test' => 'https://paynkolaytest.nkolayislem.com.tr/VposNew',
            'prod' => 'https://paynkolay.nkolayislem.com.tr/Vpos',
        ],
        'completePayment' => [

            'test' => 'https://paynkolaytest.nkolayislem.com.tr/VposNew/Payment/CompletePayment',
            'prod' => 'https://paynkolay.nkolayislem.com.tr/Vpos/Payment/CompletePayment',
        ], 
    ];
    public $debug = false;
    public $env;

    public function __construct($sx_key = '', $merchant_key = '', $env = 'test', $debug = 0 ){
        $this->sx_key = $sx_key;
        $this->merchant_key = $merchant_key;
        $this->env = $env;
        $this->debug = $debug;
    }

    public function completePayment( $reference_code ){
        if($reference_code == '')
            return [
                "status" => "fail",
                "message" => 'Referans kodu geçersiz'
            ];

        $data = [
            'sx' => $this->sx_key,
            'referenceCode' => $reference_code
        ];

        $call = $this->makeRequest( self::$urls['completePayment'][ $this->env ], $data );
        
        
        if(!$call)
            die("<div class='error warning alert'>Veri Okunamadı</div>");

        if($call["RESPONSE_CODE"] != "2"){
            $text = $call["RESPONSE_DATA"];
            return [
                "status" => "fail",
                "message" => $text
            ];
        }else{
            return [
                "status" => "success",
                "message" => "",
                "data" => $call,
            ];
        }
    }
    
    public function makeRequest($url, $going)
    {
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS,  http_build_query( $going ) );
        curl_setopt($ch, CURLOPT_POST, 1);
        $output = curl_exec($ch);


        
        if($this->debug)
        {
            echo "<div class='alert danger warning'>";
            echo "<h1>Giden Veri</h1>";
            echo "<h4>Debug Modunu Kapalı Tutunuz</h4>";
            echo "<pre>";
            var_dump( $url );
            echo "</pre>";
            echo "<pre>";
            var_dump( $going );
            echo "</pre>";
            echo "<pre>";
            var_dump( $output );
            echo "</pre>";
            echo "</div>";
            //exit;
        }

        curl_close($ch);

        if(!$output)
            die($url . " Bağlanılamıyor");

        $output = (array) json_decode(json_decode($output)->result);
        
        return $output;
    }
}

class NkolayTransaction{
    public  $apiKey;
    public  $email;
    public  $amount;
    public  $currency;
    public  $returnUrl;
    public  $referenceNo;
    public  $showInstallmentList;
    public  $language;
    public  $billingFirstName;
    public  $billingLastName;
    public  $billingCompany;
    public  $billingAddress1;
    public  $billingAddress2;
    public  $billingCity;
    public  $billingPostcode;
    public  $billingCountry;
    public  $billingPhone;
    public  $basketItems;
    public  $storeCard;
    public  $sessionId;
    public  $passwordHash;
    public  $userCreated;
}