<?php


require_once  dirname(__FILE__) . '/classes/Nkolay.php';
if (!defined('_PS_VERSION_')) {
    exit;
}

class payment_nkolay extends PaymentModule
{
    protected $_html = '';
    protected $_postErrors = array();

    public $details;
    public $owner;
    public $address;
    public $extra_mail_vars;

    public function __construct()
    {
        $this->name = 'payment_nkolay';
        $this->tab = 'payments_gateways';
        $this->version = '1.0.0';
        $this->ps_versions_compliancy = array('min' => '1.6', 'max' => '1.6.99.99');
        $this->author = 'magento-tr';
        $this->controllers = array('validation', 'payment');
        $this->is_eu_compatible = 1;

        $this->currencies = true;
        $this->currencies_mode = 'checkbox';

        $this->bootstrap = true;
        parent::__construct();

        $this->displayName = $this->l('N Kolay Öde');
        $this->description = $this->l('Accept Credit Card Payments Via N Kolay Öde');

        if (!count(Currency::checkPaymentCurrencies($this->id))) {
            $this->warning = $this->l('No currency has been set for this module.');
        }
    }
    protected function _postProcess()
    {
        if (Tools::isSubmit('btnSubmit')) {
            Configuration::updateValue('payment_nkolay_sx_key', Tools::getValue('payment_nkolay_sx_key'));
            Configuration::updateValue('payment_nkolay_merchant_secret_key', Tools::getValue('payment_nkolay_merchant_secret_key'));
            Configuration::updateValue('payment_nkolay_3d_option', Tools::getValue('payment_nkolay_3d_option'));
            Configuration::updateValue('payment_nkolay_env', Tools::getValue('payment_nkolay_env'));
            Configuration::updateValue('payment_nkolay_debug', Tools::getValue('payment_nkolay_debug'));
        }
        $this->_html .= $this->displayConfirmation($this->l('Settings updated'));
    }
    public function getContent()
    {
        if (Tools::isSubmit('btnSubmit')) {
            //$this->_postValidation();
            if (!count($this->_postErrors))
                $this->_postProcess();
            else
                foreach ($this->_postErrors as $err)
                    $this->_html .= $this->displayError($err);
        } else
            $this->_html .= '<br />';

        $this->_html .= $this->_displayInfo();
        $this->_html .= $this->renderForm();

        return $this->_html;
    }

    protected function _displayInfo()
    {
        //return $this->display(__FILE__, 'infos.tpl');
        return "";
    }

    public function renderForm()
    {
        $fields_form = array(
            'form' => array(
                'legend' => array(
                    'title' => $this->l('N Kolay Öde Parameters'),
                    'icon' => 'icon-envelope'
                ),
                'input' => array(
                    array(
                        'type' => 'text',
                        'label' => $this->l('SX Key'),
                        'name' => 'payment_nkolay_sx_key',
                        'required' => true
                    ),
                    array(
                        'type' => 'text',
                        'label' => $this->l('Merchant Secret Key'),
                        'name' => 'payment_nkolay_merchant_secret_key',
                        'required' => true
                    ),
                    array(
                        'type' => 'select',
                        'label' => $this->l('3D Secure Option'),
                        'name' => 'payment_nkolay_3d_option',
                        'required' => true,
                        'options' => array(
                            'query' => array(
                                array(
                                    'id_option' => '2d',
                                    'name' => '2D Payment'
                                ),
                                array(
                                    'id_option' => '3d',
                                    'name' => '3D Payment'
                                ),
                            ),
                            'id' => 'id_option',
                            'name' => 'name'
                        ),
                    ),
                    array(
                        'type' => 'select',
                        'label' => $this->l('Test / Prod Mode'),
                        'name' => 'payment_nkolay_env',
                        'required' => true,
                        'options' => array(
                            'query' => array(
                                array(
                                    'id_option' => 'test',
                                    'name' => 'Test'
                                ),
                                array(
                                    'id_option' => 'prod',
                                    'name' => 'Prod'
                                ),
                            ),
                            'id' => 'id_option',
                            'name' => 'name'
                        ),
                    ),
                    array(
                        'type' => 'select',
                        'label' => $this->l('Debug Mode'),
                        'name' => 'payment_nkolay_debug',
                        'required' => true,
                        'options' => array(
                            'query' => array(
                                array(
                                    'id_option' => 1,
                                    'name' => 'Enable'
                                ),
                                array(
                                    'id_option' => 0,
                                    'name' => 'Disable'
                                ),
                            ),
                            'id' => 'id_option',
                            'name' => 'name'
                        ),
                    )
                ),
                'submit' => array(
                    'title' => $this->l('Save'),
                )
            ),
        );

        $helper = new HelperForm();
        $helper->show_toolbar = false;
        $helper->table = $this->table;
        $lang = new Language((int) Configuration::get('PS_LANG_DEFAULT'));
        $helper->default_form_language = $lang->id;
        $helper->allow_employee_form_lang = Configuration::get('PS_BO_ALLOW_EMPLOYEE_FORM_LANG') ? Configuration::get('PS_BO_ALLOW_EMPLOYEE_FORM_LANG') : 0;
        $this->fields_form = array();
        $helper->id = (int) Tools::getValue('id_carrier');
        $helper->identifier = $this->identifier;
        $helper->submit_action = 'btnSubmit';
        $helper->currentIndex = $this->context->link->getAdminLink('AdminModules', false) . '&configure=' . $this->name . '&tab_module=' . $this->tab . '&module_name=' . $this->name;
        $helper->token = Tools::getAdminTokenLite('AdminModules');
        $helper->tpl_vars = array(
            'fields_value' => $this->getConfigFieldsValues(),
            'languages' => $this->context->controller->getLanguages(),
            'id_language' => $this->context->language->id
        );

        return $helper->generateForm(array($fields_form));
    }

    public function getConfigFieldsValues()
    {





        return array(
            'payment_nkolay_sx_key' => Tools::getValue('payment_nkolay_sx_key', Configuration::get('payment_nkolay_sx_key')),
            'payment_nkolay_merchant_secret_key' => Tools::getValue('payment_nkolay_merchant_secret_key', Configuration::get('payment_nkolay_merchant_secret_key')),
            'payment_nkolay_3d_option' => Tools::getValue('payment_nkolay_3d_option', Configuration::get('payment_nkolay_3d_option')),
            'payment_nkolay_env' => Tools::getValue('payment_nkolay_env', Configuration::get('payment_nkolay_env')),
            'payment_nkolay_debug' => Tools::getValue('payment_nkolay_debug', Configuration::get('payment_nkolay_debug')),
        );
    }

    public function install()
    {
        require_once dirname(__FILE__) . "/sqls.php";
        foreach ($install_sqls as $install_sql){
            $install_sql = str_replace("`ps_", "`" . _DB_PREFIX_, $install_sql);
            try {
                DB::getInstance()->execute($install_sql);
            }catch (exception $e){
                $this->_errors[] = get_class($e).': '.$e->getMessage();
                //$this->uninstall();
                return false;
            }
        }


        if (
            !parent::install()
            || !$this->registerHook('payment')
            || !$this->registerHook('paymentReturn')
            || !$this->registerHook('displayPaymentEU')
        ) {
            return false;
        }
        return true;
    }
        public function hookDisplayPaymentEU($params)
    {
        return $this->hookPayment($params);
    }
    public function hookPayment($params)
    {
        if (!$this->active)
            return;
        
        $this->smarty->assign(array(
            'nkolay_payment_link' => $this->context->link->getModuleLink( $this->name, 'payment', [], true),
            'this_path' => $this->_path,
            'this_path_bw' => $this->_path,
            'this_path_ssl' => Tools::getShopDomainSsl(true, true).__PS_BASE_URI__.'modules/'.$this->name.'/'
        ));
        return $this->display(__FILE__, 'payment.tpl');
    }

    public function checkCurrency($cart)
    {
        $currency_order = new Currency($cart->id_currency);
        $currencies_module = $this->getCurrency($cart->id_currency);

        if (is_array($currencies_module)) {
            foreach ($currencies_module as $currency_module) {
                if ($currency_order->id == $currency_module['id_currency']) {
                    return true;
                }
            }
        }
        return false;
    }
}
