<?php

class Transaction extends ObjectModel
{
    public $id;
    public $order_id;
    public $status;
    public $amount;
    public $currency;
    public $type;
    public $reference;
    public $operation;
    public $transactionId;
    public $message;
    public $code;
    public $purchase_url;

    public static $definition = array(
        'table' => 'nkolay_transactions',
        'primary' => 'id',
        'fields' => array(
            'id' => array('type' => self::TYPE_INT, ),
            'order_id' => array('type' => self::TYPE_INT, ),
            'status' => array('type' => self::TYPE_STRING, ),
            'amount' => array('type' => self::TYPE_STRING, ),
            'currency' => array('type' => self::TYPE_STRING, ),
            'type' => array('type' => self::TYPE_STRING, ),
            'reference' => array('type' => self::TYPE_STRING, ),
            'operation' => array('type' => self::TYPE_STRING, ),
            'transactionId' => array('type' => self::TYPE_STRING, ),
            'message' => array('type' => self::TYPE_STRING, ),
            'code' => array('type' => self::TYPE_STRING, ),
            'purchase_url' => array('type' => self::TYPE_STRING, ),
        ),
    );

    public function getOrderReferenceNo( $id_order ){
        return DB::getInstance()->executeS("select * from " . self::$definition["table"] . " where order_id = " . pSQL($id_order) );
    }
    public static function getTransactionFromReferenceNo( $referenceNo ){
        $result = DB::getInstance()->executeS("select id from " . self::$definition["table"] . " where reference = " . pSQL($referenceNo) );
        return new Transaction( $result["id"] );
    }
}