<?php
    require_once dirname(__FILE__) . '/../../classes/Transaction.php';

    /**
     * @since 1.5.0
     */
    class payment_nkolayvalidationModuleFrontController extends ModuleFrontController
    {
        /**
         * @see FrontController::postProcess()
         */
        public function postProcess()
        {


            $cart = $this->context->cart;
            if ($cart->id_customer == 0 || $cart->id_address_delivery == 0 || $cart->id_address_invoice == 0 || !$this->module->active) {
                Tools::redirect('index.php?controller=order&step=1');
            }

            $authorized = false;
            foreach (Module::getPaymentModules() as $module) {
                if ($module['name'] == 'payment_nkolay') {
                    $authorized = true;
                    break;
                }
            }

            if (!$authorized) {
                die($this->module->l('This payment method is not available.', 'validation'));
            }

            if (Tools::getValue('RESPONSE_CODE') != '2') {
                var_dump([$_POST, $_GET]);
                $this->context->smarty->assign([
                    'error_message' => Tools::getValue('RESPONSE_DATA'),
                ]);
                $this->setTemplate('payment_return.tpl');
            } else {

                //$hashtr = Tools::getValue('MERCHANT_NO') . Tools::getValue('REFERENCE_CODE') . Tools::getValue('AUTH_CODE') . Tools::getValue('RESPONSE_CODE') . Tools::getValue('USE_3D') . Tools::getValue('RND') . Tools::getValue('INSTALLMENT') . Tools::getValue('AUTHORIZATION_AMOUNT') . Configuration::get('payment_nkolay_merchant_secret_key');


                $hashtr['MERCHANT_NO'] = Tools::getValue('MERCHANT_NO');
                $hashtr['REFERENCE_CODE'] = Tools::getValue('REFERENCE_CODE');
                $hashtr['AUTH_CODE'] = Tools::getValue('AUTH_CODE');
                $hashtr['RESPONSE_CODE'] = Tools::getValue('RESPONSE_CODE');
                $hashtr['USE_3D'] = Tools::getValue('USE_3D');
                $hashtr['RND'] = Tools::getValue('RND');
                $hashtr['INSTALLMENT'] = Tools::getValue('INSTALLMENT');
                $hashtr['AUTHORIZATION_AMOUNT'] = Tools::getValue('AUTHORIZATION_AMOUNT');
                $hashtr['payment_nkolay_merchant_secret_key'] = Configuration::get('payment_nkolay_merchant_secret_key');
                $implode = implode('', $hashtr);
                $hashDatauretilen = base64_encode(pack('H*', sha1($implode)));

                /* HASH CTRL
                echo "<pre>";
                var_dump([
                    'POSTDATA' => $_POST,
                    'HASHLIST' => $hashtr,
                    'IMPLODED' => $implode,
                    'HASHED' => $hashDatauretilen,
                    'YOUR-HASHED' => Tools::getValue('hashData'),
                    'COMPARE' => Tools::getValue('hashData') == $hashDatauretilen
                ]);
                echo "</pre>";
                exit;
                */

                if (Tools::getValue('hashData') != $hashDatauretilen) {
                    $this->context->smarty->assign([
                        'error_message' => 'Hash doğrulaması başarısız',
                    ]);
                    $this->setTemplate('payment_return.tpl');
                    return;
                }

                //CompletePayment
                $nkolay = new Nkolay(
                    Configuration::get('payment_nkolay_sx_key'),
                    Configuration::get('payment_nkolay_merchant_secret_key'),
                    Configuration::get('payment_nkolay_env'),
                    Configuration::get('payment_nkolay_debug')
                );
                //$nkolay->debug = true;


                if (Tools::getValue('USE_3D') == 'true') {
                    $confirmPaymentAction = $nkolay->completePayment(Tools::getValue('REFERENCE_CODE'));

                    if ($confirmPaymentAction['status'] != 'success') {


                        $this->context->smarty->assign([
                            'error_message' => $confirmPaymentAction['message'],
                        ]);
                        $this->setTemplate('module:payment_nkolay/views/templates/front/payment_return.tpl');
                        return;
                    }
                }


                $customer = new Customer($this->context->customer->id);
                if (!Validate::isLoadedObject($customer))
                    Tools::redirect('index.php?controller=order&step=1');
                $currency = $this->context->currency;
                $total = (float)$cart->getOrderTotal(true, Cart::BOTH);
                $mailVars = array();

                $customer_secure_key = false;
                if ($customer and $customer->secure_key)
                    $customer_secure_key = $customer->secure_key;


                $this->module->validateOrder($cart->id, Configuration::get('PS_OS_PAYMENT'), $total, $this->module->displayName, NULL, $mailVars, (int)$currency->id, false, $customer_secure_key);
                Tools::redirect('index.php?controller=order-confirmation&id_cart=' . $cart->id . '&id_module=' . $this->module->id . '&id_order=' . $this->module->currentOrder . '&key=' . $customer_secure_key);

                return;
            }
        }

        public function curl($par, $url)
        {
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_HTTPHEADER, array());
            curl_setopt($ch, CURLOPT_URL, $url);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_HEADER, false);
            curl_setopt($ch, CURLOPT_POST, 1);
            curl_setopt($ch, CURLOPT_POSTFIELDS, $par);
            $output = curl_exec($ch);
            curl_close($ch);
            return $output;
        }
    }
