<?php
/**
 * WC_Gateway_Paynkolay class
 *
 * @author   SomewhereWarm <info@somewherewarm.gr>
 * @package  WooCommerce Paynkolay Payments Gateway
 * @since    1.0.0
 */

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Paynkolay Gateway.
 *
 * @class    WC_Gateway_Paynkolay
 * @version  1.0.7
 */
class WC_Gateway_Paynkolay extends WC_Payment_Gateway {

	/**
	 * Payment gateway instructions.
	 * @var string
	 *
	 */
	protected $instructions;

	/**
	 * Whether the gateway is visible for non-admin users.
	 * @var boolean
	 *
	 */
	protected $hide_for_non_admin_users;

	/**
	 * Unique id for the gateway.
	 * @var string
	 *
	 */
	public $id = 'paynkolay';

    /**
     * Test mode setting.
     * @var string
     */
    public $testmode;

    /**
     * Token (SX).
     * @var string
     */
    public $token;

    /**
     * Merchant Secret Key.
     * @var string
     */
    public $merchant_secret_key;

	/**
	 * Constructor for the gateway.
	 */
	public function __construct() {
		
		$this->icon               = apply_filters( 'woocommerce_paynkolay_gateway_icon', '' );
		$this->has_fields         = false;
		$this->supports           = array(
			'products',
			'subscriptions',
			'subscription_cancellation',
			'subscription_suspension',
			'subscription_reactivation',
			'subscription_amount_changes',
			'subscription_date_changes',
			'multiple_subscriptions'
		);

		$this->method_title       = _x( 'Pay N Kolay', 'Paynkolay payment method', 'woocommerce-gateway-paynkolay' );
		$this->method_description = __( 'Ödemenizi Paynkolay ile güvenli bir şekilde yapabilirsiniz.', 'woocommerce-gateway-paynkolay' );

		// Load the settings.
		$this->init_form_fields();
		$this->init_settings();

		// Define user set variables.
		$this->title = $this->get_option('title');
		$this->description = $this->get_option('description');
		$this->testmode = $this->get_option('testmode');
		$this->token = $this->get_option('token');
		$this->merchant_secret_key = $this->get_option('merchant_secret_key');

		add_action( 'woocommerce_update_options_payment_gateways_' . $this->id, array( $this, 'process_admin_options' ) );
		add_action( 'woocommerce_scheduled_subscription_payment_paynkolay', array( $this, 'process_subscription_payment' ), 10, 2 );
		add_action( 'woocommerce_receipt_' . $this->id, array( $this, 'receipt_page' ) );
		add_action( 'woocommerce_api_paynkolay', array( $this, 'webhook' ));
	}

	/**
	 * Initialise Gateway Settings Form Fields.
	 */
	public function init_form_fields() {

		$this->form_fields = array(
			'enabled' => array(
				'title'   => 'Aktif/Pasif',
				'type'    => 'checkbox',
				'label'   => 'Ödeme yöntemini aktifleştir.',
				'default' => 'yes',
			),
			'title' => array(
				'title'       => 'Başlık',
				'type'        => 'text',
				'description' => 'Ödeme sayfasındaki başlığı bu alandan değiştirebilirsiniz.',
				'default'     => 'Kredi Kartı ile Öde',
				'desc_tip'    => true,
			),
			'description' => array(
				'title'       => 'Açıklama',
				'type'        => 'textarea',
				'description' => 'Ödeme sayfasındaki açıklamayı bu alandan değiştirebilirsiniz.',
				'default'     => 'Paynkolay ile güvenli bir şekilde ödeme yapabilirsiniz.',
			),
			'testmode' => array(
				'title'       => 'Test Mod',
				'label'       => 'Test modunu aktifleştir.',
				'type'        => 'checkbox',
				'description' => 'Test modunu aktifleştirerek test kartları ile ödeme yapabilirsiniz.',
				'default'     => 'yes',
			),
			'token' => array(
				'title'       => 'Token (SX)',
				'type'        => 'text',
				'description' => 'Paynkolay yönetim panelinden alacağınız Token (SX Değeri) bilgisini bu alana girebilirsiniz.',
			),
			'merchant_secret_key' => array(
				'title'       => 'Merchant Secret Key',
				'type'        => 'text',
				'description' => 'Paynkolay yönetim panelinden alacağınız Merchant Secret Key bilgisini bu alana girebilirsiniz.',
			)
		);
	}

	/**
	 * Process the payment and return the result.
	 *
	 * @param  int  $order_id
	 * @return array
	 */
	public function process_payment($order_id)
	{
		$order = wc_get_order($order_id);

		return array(
			'result' => 'success',
			'redirect' => $order->get_checkout_payment_url(true)
		);
	}

	/**
	 * Process subscription payment.
	 *
	 * @param  float     $amount
	 * @param  WC_Order  $order
	 * @return void
	 */
	public function process_subscription_payment( $amount, $order )
	{
		$payment_result = $this->get_option( 'result' );

		if ( 'success' === $payment_result ) {
			$order->payment_complete();
		} else {
			$message = __( 'Order payment failed. To make a successful payment using Paynkolay Payments, please review the gateway settings.', 'woocommerce-gateway-paynkolay' );
			throw new Exception( $message );
		}
	}

	function receipt_page($order_id)
	{
		$order = wc_get_order($order_id);

		require_once plugin_dir_path( __DIR__ ) . 'views/iframe.php';
	}

	public function webhook()
	{
		$response = $_REQUEST;

		if($_SERVER['REQUEST_METHOD'] != 'POST') {
			//$this->log('Webhook received with invalid request method: ' . $_SERVER['REQUEST_METHOD']);
			header('Location: ' . wc_get_checkout_url() . '?success=false&Reason=' . base64_encode('Geçersiz istek yöntemi.'));
			exit;
		}

		// if ($response['RESPONSE_CODE'] != 2) {
		// 	//$this->log('Webhook received with error: ' . $response['RESPONSE_CODE']);
		// 	header('Location: ' . $order->get_checkout_payment_url() . '&Reason=' . base64_encode($RESPONSE_DATA));
		// 	exit;
		// }

		$MERCHANT_SECRET_KEY = get_option('woocommerce_paynkolay_settings')['merchant_secret_key'];

		$REFERENCE_CODE = isset($_POST['REFERENCE_CODE']) ? $_POST['REFERENCE_CODE'] : false;

		$RESPONSE_CODE = $_POST['RESPONSE_CODE'];
		$RESPONSE_DATA = $_POST['RESPONSE_DATA'];
		$USE_3D = $_POST['USE_3D'];
		$MERCHANT_NO = $_POST['MERCHANT_NO'];
		$AUTH_CODE = $_POST['AUTH_CODE'];
		$CLIENT_REFERENCE_CODE = $_POST['CLIENT_REFERENCE_CODE'];
		$AUTHORIZATION_AMOUNT = $_POST['AUTHORIZATION_AMOUNT'];
		$INSTALLMENT = $_POST['INSTALLMENT'];
		$RND = $_POST['RND'];
		$HASHDATA = $_POST['hashData'];

		$HASHTR = $MERCHANT_NO . $REFERENCE_CODE . $AUTH_CODE . $RESPONSE_CODE . $USE_3D . $RND . $INSTALLMENT . $AUTHORIZATION_AMOUNT . $MERCHANT_SECRET_KEY ;
		$HASH_CREATED = base64_encode(pack('H*',sha1($HASHTR)));

		


		global $woocommerce;
		global $wpdb;
		$postmeta = $wpdb->get_row($wpdb->prepare("SELECT * FROM {$wpdb->prefix}postmeta WHERE meta_key = 'client_reference_code' AND meta_value = '%s'", $response['CLIENT_REFERENCE_CODE']));

		if(!isset($postmeta->post_id)) {
			//$this->log('Webhook received with invalid client reference code: ' . $response['CLIENT_REFERENCE_CODE']);
			header('Location: ' . wc_get_checkout_url() . '?success=false&Reason=' . base64_encode($_POST['RESPONSE_DATA']));
			exit;
		}

		if($this->get_option('testmode') == 'yes') {
			$complete_payment_url = 'https://paynkolaytest.nkolayislem.com.tr/Vpos/v1/CompletePayment';
		} else {
			$complete_payment_url = 'https://paynkolay.nkolayislem.com.tr/Vpos/v1/CompletePayment';
		}

		$order = wc_get_order($postmeta->post_id);

		/*
		$response = wp_remote_post($complete_payment_url, [
			'body' => [
				'sx' => $this->get_option('token'),
				'referenceCode' => $REFERENCE_CODE,
			]
		]);
		$response = json_decode($response['body']);
		*/
		// echo "hashData :".$HASHDATA;
		// echo "<br>";
		// echo "hash üretilen: ".$HASH_CREATED;

		if($HASHDATA != $HASH_CREATED) {
			header('Location: ' . $order->get_checkout_payment_url() . '&success=false&Reason=' . base64_encode("HASH uyuşmazlığı! Üye işyeri iletişime geçiniz."));
			exit;
		}
		
		// Omer added this to prevent duplicate transactions
		if ($response['RESPONSE_CODE'] == 0 && strpos($response['RESPONSE_DATA'], "Bu referans numarası için daha önce işlem yapılmıştır") !== false) {
			exit("Transaction already processed for this reference number.");
		}
		
		if($response['RESPONSE_CODE'] != 2 ) {
			////$this->log('Webhook received with invalid response code: ' . $response->RESPONSE_CODE);
			header('Location: ' . $order->get_checkout_payment_url() . '&success=false&Reason=' . base64_encode($RESPONSE_DATA));
			exit;
		}

		if($RESPONSE_CODE == 2 && $AUTH_CODE) {
			$order->payment_complete();
			$order->update_status('processing');
			$woocommerce->cart->empty_cart();
			header('Location: ' . $order->get_checkout_order_received_url());
			exit;
		}


		
		header('Location: ' . $order->get_checkout_payment_url() . '&success=false&Reason=' . base64_encode("Üye işyerinin Nkolay ile iletişime geçmesi gerekmektedir.(AutoComplate Açılmalıdır.)"));
		exit;
	}
}